<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Superio
 * @since Superio 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Corporation",
  "name": "Vieclamnhanvienkinhdoanh.com - Nơi kết nối ứng viên và nhà tuyển dụng",
  "alternateName": "Vieclamnhanvienkinhdoanh.com",
  "url": "https://vieclamnhanvienkinhdoanh.com/",
  "logo": "http://vieclamnhanvienkinhdoanh.com/wp-content/uploads/elementor/thumbs/marketing-qkjt1asr81634loh186olz5pne9mqxoche7qhmloe6.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "0845 026 157",
    "contactType": "technical support",
    "contactOption": "TollFree",
    "areaServed": "VN",
    "availableLanguage": "Vietnamese"
  },
  "sameAs": [
    "https://sites.google.com/view/vieclamnhanvienkinhdoanh/",
    "https://www.youtube.com/channel/UCIqOiJZyn8OZniJmywmJzMg/about",
    "https://twitter.com/nhanvienkd",
    "https://www.reddit.com/user/vieclamnhanvienkd/",
    "https://www.linkedin.com/in/vieclamnhanvienkinhdoanh/",
    "https://vieclamnhanvienkd.blogspot.com/",
    "https://www.pinterest.com/vieclamnhanvienkd/",
    "https://vieclamnhanvienkinhdoanh.tumblr.com/"
  ]
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "Vieclamnhanvienkinhdoanh.com - Nơi kết nối ứng viên và nhà tuyển dụng",
  "image": "http://vieclamnhanvienkinhdoanh.com/wp-content/uploads/elementor/thumbs/marketing-qkjt1asr81634loh186olz5pne9mqxoche7qhmloe6.png",
  "@id": "https://vieclamnhanvienkinhdoanh.com/",
  "url": "https://vieclamnhanvienkinhdoanh.com/",
  "telephone": "0845 026 157",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "47 Phan Đình Thông, An Lạc, Bình Tân, Thành phố Hồ Chí Minh, Việt Nam",
    "addressLocality": "Thành phố Hồ Chí Minh",
    "postalCode": "70000",
    "addressCountry": "VN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 10.7357686,
    "longitude": 106.6200009
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://sites.google.com/view/vieclamnhanvienkinhdoanh/",
    "https://www.youtube.com/channel/UCIqOiJZyn8OZniJmywmJzMg/about",
    "https://twitter.com/nhanvienkd",
    "https://www.reddit.com/user/vieclamnhanvienkd/",
    "https://www.linkedin.com/in/vieclamnhanvienkinhdoanh/",
    "https://vieclamnhanvienkd.blogspot.com/",
    "https://www.pinterest.com/vieclamnhanvienkd/",
    "https://vieclamnhanvienkinhdoanh.tumblr.com/"
  ] 
}
</script>
	<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Person",
  "name": "Kiều Minh Đức",
  "url": "https://vieclamnhanvienkinhdoanh.com/author/admin/",
  "image": "https://htmediagroup.vn/wp-content/uploads/2022/02/Doanh-nhan-nghe-thuat-1-min.jpg",
  "sameAs": [
    "https://sites.google.com/view/kieuminhduc/",
    "https://www.youtube.com/channel/UCpAh5CGDftCKkKQmUhQU8Nw/about",
    "https://twitter.com/ceokieuminhduc",
    "https://ceokieuminhduc.blogspot.com/",
    "https://www.pinterest.com/ceokieuminhduc/",
    "https://kieuminhduc.tumblr.com/",
    "https://www.blogger.com/profile/08417542594247924263",
    "https://about.me/kieuminhduc/"
  ],
  "jobTitle": "CEO",
  "worksFor": {
    "@type": "Organization",
    "name": "vieclamnhanvienkinhdoanh.com"
  }  
}
</script>
	
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-Q10VJCJBLZ"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-Q10VJCJBLZ');
</script>
	<meta name='dmca-site-verification' content='OWc1Z1l6MzNYcDhCWGVhczAzSHZrYmYzaURsNWw1Yi9oSXJyZUx2aUdBdz01' />
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="//gmpg.org/xfn/11">
	
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php if ( superio_get_config('preload', true) ) {
	$preload_icon = superio_get_config('media-preload-icon');
	$styles = array();
	if ( !empty($preload_icon['id']) ) {
		$img = wp_get_attachment_image_src($preload_icon['id'], 'full');
		if ( !empty($img[0]) ) {
			$styles[] = 'background-image: url(\''.$img[0].'\');';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'width: '.$img[1].'px;';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'height: '.$img[2].'px;';
		}
    }
    $style_attr = '';
    if ( !empty($styles) ) {
    	$style_attr = 'style="'.implode(' ', $styles).'"';
    }
?>
	<div class="apus-page-loading">
        <div class="apus-loader-inner" <?php echo trim($style_attr); ?>></div>
    </div>
<?php } ?>
<div id="wrapper-container" class="wrapper-container">
	<?php
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    }
    if ( superio_get_config('separate_header_mobile', true) ) {
	    get_template_part( 'headers/mobile/offcanvas-menu' );
		get_template_part( 'headers/mobile/header-mobile' );
	}
	?>

	<?php
		$header = apply_filters( 'superio_get_header_layout', superio_get_config('header_type') );
		if ( !empty($header) ) {
			superio_display_header_builder($header);
		} else {
			get_template_part( 'headers/default' );
		}
	?>
	<div id="apus-main-content">